#include "texteditor.h"
#include <QFile>
#include <QTextStream>

TextEditor::TextEditor(QWidget *parent)
    : QWidget(parent), m_textEdit(new QTextEdit(this))
{
    auto layout = new QVBoxLayout(this);
    layout->addWidget(m_textEdit);
    setLayout(layout);
}

bool TextEditor::loadFile(const QString &fileName)
{
    QFile file(fileName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return false;

    QTextStream in(&file);
    m_textEdit->setPlainText(in.readAll());
    setCurrentFile(fileName);
    return true;
}

bool TextEditor::saveFile(const QString &fileName)
{
    QFile file(fileName);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
        return false;

    QTextStream out(&file);
    out << m_textEdit->toPlainText();
    setCurrentFile(fileName);
    return true;
}

void TextEditor::setCurrentFile(const QString &fileName)
{
    m_fileName = fileName;
}
